$(function(){
	$("a.dropdown").click(function(e){
		e.preventDefault();
		if(!$('.mapDrop').is(':visible')){
			$(this).contents().last()[0].textContent = 'Close map';
			$(this).find('i').removeClass('icon-chevron-down').addClass('icon-chevron-up');
			$(this).closest('.searchSortBar').addClass('noBottomRigthCorner');
			$('.mapDrop').slideDown('slow', function(){
				load_map();
			});
		}else{
			$(this).contents().last()[0].textContent = 'See map';
			$(this).find('i').removeClass('icon-chevron-up').addClass('icon-chevron-down');
			var $item = $(this);
			$('.mapDrop').slideUp('normal', function() {
				$item.closest('.searchSortBar').removeClass('noBottomRigthCorner');
			});
		}
	});
});

$(document).ready(function(){
	function updateFavoritesCount() {
		$.get(_url_ + "ajaxRequests.php", { get: "favoritesCount" }, function(data) {
			if(data != "#ERROR#"){
				$('span#menuFavsCount').html(data);
			}
		});
	}
	
	$('#sCountry').change(function(){
		$.get(_url_ + "ajaxRequests.php", { get: "regions", id: $('#sCountry option:selected').attr('data-id'), byURL: "true" }, function(data) {			
			$('#sRegion').empty();
			$('#sRegion').append('<option value="ALL">All</option>');
			$('#sRegion').append(data);
		});
	});
	
	$('.setFavoriteBtn').click(function(e){
		e.preventDefault();
		var id_course = $(this).data("id");
		
		if($(this).attr("data-status") == "true")
			currentState = true;
		else
			currentState = false;
		
		console.debug(currentState);
		$clickedBtn = $(this);
		
		$clickedBtn.find('i').attr('class', '');
		if(currentState){
			$clickedBtn.find('i').addClass("icon-star-empty");
			$clickedBtn.removeClass('btn-warning');
		}else{
			$clickedBtn.find('i').addClass("icon-star icon-white");
			$clickedBtn.addClass('btn-warning');
		}
		
		currentState = currentState?false:true;
		
		$.get(_url_ + "ajaxRequests.php", { set: "favorite", id: id_course, value: currentState }, function(data) {
			if(data != "#OK#"){
				$clickedBtn.find('i').attr('class', '');
				if(currentState){
					$clickedBtn.find('i').addClass("icon-star-empty");
					$clickedBtn.removeClass('btn-warning');
				}else{
					$clickedBtn.find('i').addClass("icon-star icon-white");
					$clickedBtn.addClass('btn-warning');
				}
				
				if(data == "#NOT_LOGGED_IN#"){
					if(Boolean(confirm("You need to login in order to add this course to your favorites.\nDo tou want to do it now?"))) {
						window.location = _url_ + "account/login.html";
					}
				}
			}else{
				$clickedBtn.attr("data-status", currentState.toString());
				updateFavoritesCount();
			}
		});
	});
	
	$('.removeFavBtn').click(function(e){
		e.preventDefault();
		var id_course = $(this).data("id");
		if(Boolean(confirm("Are you sure you want to remove this course from your favorites list?"))){
			$.get(_url_ + "ajaxRequests.php", { set: "favorite", id: id_course, value: false }, function(data) {
				if(data == "#OK#"){
					window.location.reload();
				}else{
					alert("It was not possible to remove this course from your favorites at this time. Try again later.");
				}
			});
		}
	});
});