// *********************************************************************************
// Generic Forms Validator v1.3 (w/ Twitter's Bootstrap Support)
// Author: Joni Dias @ Livetech.pt (joni.dias@livetech.pt)
//
// ******** How to use ********
// Add the following classes to the input:
// 'required' - mandatory field
// 'email' - email field
// 'matchPasswords' - validates two password fields that must mach (the 2nd password field must have the same name as the 1st plus the string 'Confirm'; this class only needs to be aplied to first password field)
// 'numeric' - numeric field
// 'phoneNr' - phone number field
// 'url' - url field
//
// ******** Aditional Functionalities ********
// ### Prevents different field type chars from being inserted
// Add 'filterKeys' followed by one of the following classes: 'numeric' or 'url' (description above)
//
// ### Validate required checkboxes (useful for website terms and conditions agreement)
// Add 'required' as class, add 'title' attribute (optional) to show an alert box, otherwise default message is shown inline
//
// ### Disables validation for a specific form (all forms are validated by default as long as validation rules do exist on the form fields)
// Add 'ignoreValidation' as class to a form which should not be validated
//
// ### Add dependencies between fields (ex: trigger empty Confirm Password field only if the underlying password field is filled in)
// Add 'dependsOn' as class followed by the IDs of the fields this current field depends on
// Ex: id="field3" class="numeric dependsOn field1 field2"
// IMPORTANT: this option must be the LAST ONE in the class string, which means that nothing can be written following this
//
// ### Some Notes
// SELECT element types must have the default option with value defined as "NA" in order to validation be able to work properly
//
// *********************************************************************************

var options = {
		validateOnBlur: true, // if true, validates form showing error messages everytime an element loose its focus
		customMessageActions: true // if true, uses custom actions for validation messages
};

/* Custom messages ADD and REMOVE behavior - Twitter's Bootstrap */
function customAddErrorMsgActions(msg, $elem, $additionalClass) {
	$additionalClass = ($additionalClass==undefined)?"":$additionalClass;
	$elem.parents('.control-group:first').addClass("error");
	$elem.parent().append('<span class="help-inline">' + msg + '</span>');
}

function customRemoveErrorMsgActions($elem, animation) {
	$elem.parents('.control-group:first').removeClass("error");
	$elem.next('span.help-inline').hide((animation)?'normal':'').remove();
}

/* Default message handling functions */
function addErrorMsg(msg, $elem, $additionalClass) {
	var itemClicked = ($elem.data("clicked")=="1")?true:false;
	if((options.validateOnBlur && itemClicked) || !options.validateOnBlur){
		if(options.customMessageActions){
			customAddErrorMsgActions(msg, $elem, $additionalClass);
			return;
		}
		
		$additionalClass = ($additionalClass==undefined)?"":$additionalClass;
		remErrorMsg($elem);
		if($additionalClass != ""){
			$additionalClass = " " + $additionalClass;
		}
		
		$elem.parent().append('<br><span class="error' + $additionalClass + '"> * ' + msg + '</span>');
	}
}

function remErrorMsg($elem, animation) {
	animation = (animation==undefined)?false:animation;
	
	if(options.customMessageActions){
		customRemoveErrorMsgActions($elem, animation);
		return;
	}
	
	$elem.parent().find('.error').prev('br').hide((animation)?'normal':'').remove();
	$elem.parent().find('.error').hide((animation)?'normal':'').remove();
}

$(document).ready(function(){
	
    var validate = function($form) {
		 var errorsFound = false;
		 
		 $form.find('input[type="text"], input[type="password"], input[type="checkbox"], textarea, select').each(function() {
			// Clear all existant error messages
			 remErrorMsg($(this), false);
			 
			// Validate required fields
	     	if($(this).val() == "" && $(this).hasClass('required')) {	     			
					addErrorMsg("required field", $(this));
					errorsFound = true;
	     	}
	     	
	     	// Validate field dependencies
 			if($(this).val() == "" && $(this).hasClass('dependsOn')) {
 				var classes = $(this).attr('class').split(" ");
 				var dependentIDs = [];
 				var start = false;
 				$.each(classes, function(){
 					if(start)
 						dependentIDs.push(this.toString());
 					if(this.toString() == 'dependsOn')
 						start = true;
 				});
 				
 				$curElem = $(this);
 				$.each(dependentIDs, function(){
 					if($('#' + this.toString()).length > 0 && $('#' + this.toString()).val() != "" && !errorsFound){
 						addErrorMsg("required field", $curElem);
 						errorsFound = true;
 					}
 				});
 			}
	     	
	     	if($(this).is("select")) {
	     		if($(this).hasClass('required') && $(this).find('option:selected').val() == 'NA') {
					addErrorMsg("selection required", $(this), 'selectField');
					errorsFound = true;
		     	}
	     	}
	     	
	     	if($(this).is('input[type="checkbox"]')) {
	     		if($(this).hasClass('required') && !$(this).is(':checked')) {
	     			if($(this).attr('title') != '') {
						alert($(this).attr('title'));
						errorsFound = true;
			     	}else{
			     		addErrorMsg("option required to be checked", $(this));
			     	}
	     		}
	     	}
	     	
	     	// Validate email address fields
	     	if($(this).val() != "" && $(this).hasClass('email')) {
		        var pattern = new RegExp(/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i);
		        if(!pattern.test($(this).val())) {
					addErrorMsg("invalid email address", $(this));
					errorsFound = true;
		        }
	     	}

	     	// Validate match passwords required fields
	     	if($(this).val() != "" && $(this).hasClass('matchPasswords')) {
		     	if($(this).val() != $('input[name="' + $(this).attr('name') + 'Confirm"]').val() && ($('input[name="' + $(this).attr('name') + 'Confirm"]').val() != "" && $('input[name="' + $(this).attr('name') + 'Confirm"]').hasClass('required'))) {
					addErrorMsg("passwords do not match", $(this));
					if($('input[name="' + $(this).attr('name') + 'Confirm"]').val() != "")
						addErrorMsg("passwords do not match", $('input[name="' + $(this).attr('name') + 'Confirm"]'));
					errorsFound = true;
		     	}
	     	}
	     	
	     	// Validate Numeric Field
	     	if($(this).val() != "" && $(this).hasClass('numeric')) {
	     		if($(this).val().match(/[^\d]/)) {
	     			addErrorMsg("this field accepts numeric values only", $(this));
	     			errorsFound = true;
	     		}
	     	}
	     	
	     	// Validate Phone Number
	     	if($(this).val() != "" && $(this).hasClass('phoneNr')) {
	     		if($(this).val().match(/[^0-9-+]/)) {
	     			addErrorMsg("invalid number", $(this));
	     			errorsFound = true;
	     		}
	     	}
	     	
	     	// Validate URL
	     	if($(this).val() != "" && $(this).hasClass('url')) {
	     		var urlregex = new RegExp(/^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/);
	     		if(!urlregex.test($(this).val())) {
	     			addErrorMsg("invalid address", $(this));
	     			errorsFound = true;
	     		}
	     	}
	     	
		 });
		 
		 return errorsFound;
    };
    
	$("form").submit(function(e) {
	     var self = this;
	     
	     if(!$(this).hasClass('ignoreValidation')){
	    	 e.preventDefault();
	     }else{
	    	 self.submit();
	    	 return;
	     }
	     
		 var errorsFound = validate($(this));
			
	     if(!errorsFound) {
			$(this).find('input[type="submit"]').each(function() {
				$(this).attr("disabled","disabled");
			});
			self.submit();
	     }
	});

	$('form').each(function(){
		// Prevents diffferent field type chars from being inserted
		$(this).find('input[type="text"].filterKeys, input[type="password"].filterKeys, textarea.filterKeys').each(function() {
			
			// Numeric field
			if($(this).hasClass('numeric')) {
				$(this).keyup(function() {
					$(this).val($(this).val().replace(/[^\d]/, ''));
				});
			}
			
			// Add http protocol to fields on click
			if($(this).hasClass('url')) {
				$(this).keyup(function(){
				    if( this.value.indexOf('http://') !== 0 ){
				        this.value = 'http://';
				    }
				})
				.click(function(){
					if($(this).val() == '')
						$(this).val('http://');
				})
				.blur(function(){
					if($(this).val() == '' || ($(this).val() == 'http://' )) {
						$(this).val('');
					}
				});;
			}
		});
		
		// Sets validation on form submit
		$(this).submit(function(e) {
		     var self = this;
		     
		     options.validateOnBlur = false;
		     
		     if(!$(this).hasClass('ignoreValidation')){
		    	 e.preventDefault();
		     }else{
		    	 self.submit();
		    	 return;
		     }
		     
			 var errorsFound = validate($(this));
				
		     if(!errorsFound) {
				$(this).find('input[type="submit"]').each(function() {
					$(this).attr("disabled","disabled");
				});
				self.submit();
		     }
		});
		
		if(options.validateOnBlur){
			$form = $(this);
			$(this).find('input[type="text"], input[type="password"], input[type="checkbox"], textarea, select').each(function() {
				$(this).blur(function(){
					validate($form);
				}).focus(function(){
					$(this).data("clicked", "1");
				});
			});
		}
	});
});