<?php 
	if($courses == array()) {
?>
<section class="listing">
	<article class="styledBox">
		<div class="content msgOnly">
			No search results found.
		</div>
	</article>
</section>
<?php }else{ ?>
<section class="searchSortBar styledBox">
	<label>Sort:</label>
	<ul>
		<li<?php echo !isset($_GET['sort'])?' class="active"':''; ?>><a href="<?php echo get_url_with_parameter('sort', ''); ?>">Recent</a></li>
		<li<?php echo (isset($_GET['sort']) && $_GET['sort'] == 'rating')?' class="active"':''; ?>><a href="<?php echo get_url_with_parameter('sort', 'rating'); ?>">Rating</a></li>
		<li<?php echo (isset($_GET['sort']) && $_GET['sort'] == 'popular')?' class="active"':''; ?>><a href="<?php echo get_url_with_parameter('sort', 'popular'); ?>">Popularity</a></li>
	</ul>
	<a href="" class="dropdown btn btn-mini"><i class="icon-chevron-down"></i>See map</a>
</section>

<div class="mapContainer">
	<div id="google_map" class="mapDrop styledBox" style="width: 478px; height: 400px;">
	</div>
</div>

<section class="listing">
	<?php foreach($courses as $course) { ?>
	<article class="styledBox">
		<?php
	if (!empty($course['image'])){
		?><figure><img src="<?php  echo ($course['image'] != "")?_url_ . url_image('imagens/', $course['image'], 100, 100, 1, 1):''; ?>"></figure><?
	}
	?>
		<div class="content"<?=empty($course['image'])?' style="width:100%"':''?>>
			<ul class="buttons">
				<li><a href="" class="btn btn-small setFavoriteBtn<?php echo array_key_exists($course['id_course'], $favorites)?' btn-warning':''; ?>" data-id="<?php echo $course['id_course']; ?>" data-status="<?php echo array_key_exists($course['id_course'], $favorites)?'true':'false'; ?>"><i class="icon-star<?php echo array_key_exists($course['id_course'], $favorites)?' icon-white':'-empty'; ?>"></i>Favorite</a></li>
				<li><a href="<?php echo $course['url']; ?>" class="btn btn-small btn-primary">See More</a></li>
			</ul>
			<h1><a href="<?php echo $course['url']; ?>"><?php echo $course['name']; ?></a><span class="rating rating_<?php echo $course['rating']; ?>"></span></h1>
			<h2><a href="<?php echo $course['paisURL']; ?>"><?php echo $course['pais']; ?></a><?php if(!empty($course['estado'])):?> &gt; <a href="<?php echo $course['estadoURL']; ?>"><?php echo $course['estado']; ?></a><?php endif; ?></h2>
			<p><?php echo $course['summary']; ?></p>
		</div>
	</article>
	<?php } ?>
</section>
<?php echo paginateHTML_custom($paginatedQuery); } ?>
<div class="bannerFullWidth">
	<?php echo getRandomBanner($banners, 5); ?>
</div>
<?
	if (false){
?>
<div class="itemsBar">
	<section class="styledBox">
		<h1 class="pull-left">Online Store</h1>
		<ul class="shopCategories nav nav-pills pull-right">
	   		<li><a href="#">Category 1</a></li>
	   		<li><a href="#">Category 2</a></li>
	   		<li><a href="#">Category 3</a></li>
	   		<li><a href="#">Category 4</a></li>
	    </ul>
		<ul class="products centeredTitle">
			<li>
				<article>
					<figure>
						<img src="<?php echo _url_; ?>ximages/product_sample_block.jpg" alt="Product Pic">
						<figcaption>Product Name</figcaption>
					</figure>
					<p>
						<span class="captionMini">€15.00</span><span class="caption label label-info">€12.00</span>
					</p>
					<div class="buttons">
						<a href="" class="btn btn-small btn-info">Info</a>
						<a href="" class="btn btn-small btn-success">Buy</a>
					</div>
				</article>
			</li>
			<li>
				<article>
					<figure>
						<img src="<?php echo _url_; ?>ximages/product_sample_block_2.jpg" alt="Product Pic">
						<figcaption>Product Name</figcaption>
					</figure>
					<p>
						<span class="captionMini">€15.00</span><span class="caption label label-info">€12.00</span>
					</p>
					<div class="buttons">
						<a href="" class="btn btn-small btn-info">Info</a>
						<a href="" class="btn btn-small btn-success">Buy</a>
					</div>
				</article>
			</li>
			<li>
				<article>
					<figure>
						<img src="<?php echo _url_; ?>ximages/product_sample_block_3.jpg" alt="Product Pic">
						<figcaption>Product Name</figcaption>
					</figure>
					<p>
						<span class="captionMini">€15.00</span><span class="caption label label-info">€12.00</span>
					</p>
					<div class="buttons">
						<a href="" class="btn btn-small btn-info">Info</a>
						<a href="" class="btn btn-small btn-success">Buy</a>
					</div>
				</article>
			</li>
			<li>
				<article>
					<figure>
						<img src="<?php echo _url_; ?>ximages/product_sample_block_4.jpg" alt="Product Pic">
						<figcaption>Product Name</figcaption>
					</figure>
					<p>
						<span class="captionMini">€15.00</span><span class="caption label label-info">€12.00</span>
					</p>
					<div class="buttons">
						<a href="" class="btn btn-small btn-info">Info</a>
						<a href="" class="btn btn-small btn-success">Buy</a>
					</div>
				</article>
			</li>
			<li>
				<article>
					<figure>
						<img src="<?php echo _url_; ?>ximages/product_sample_block_5.jpg" alt="Product Pic">
						<figcaption>Product Name</figcaption>
					</figure>
					<p>
						<span class="captionMini">€15.00</span><span class="caption label label-info">€12.00</span>
					</p>
					<div class="buttons">
						<a href="" class="btn btn-small btn-info">Info</a>
						<a href="" class="btn btn-small btn-success">Buy</a>
					</div>
				</article>
			</li>
		</ul>
	</section>
</div>
<?
	}
?>
<div class="bannerFullWidth">
	<?php echo getRandomBanner($banners, 6); ?>
</div>

<script src="http://maps.google.com/maps/api/js?sensor=false" type="text/javascript"></script>
<script type="text/javascript">
var map=null;
var courses=new Array();

<?php foreach($courses as $course) { ?>
courses.push(Array('<?php echo addslashes ($course['name']); ?>',
	<?php echo $course['lat']; ?>,
	<?php echo $course['lon']; ?>,
	10,
	'<?php echo $course['url']; ?>',
	null
));
<?php } ?>

function load_map(){
    var myOptions = {
      zoom: 4,
      mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    map = new google.maps.Map(document.getElementById("google_map"), myOptions);
    var bounds = new google.maps.LatLngBounds();
	for(var x in courses){
		var i=courses[x];
		var latlng=new google.maps.LatLng(i[1],i[2]);
		courses[x][5]= new google.maps.Marker({
			anchorPoint: google.maps.Point(0, 0),
			position: latlng,
			map: map,
			title: i[0],
			icon: '<?php echo _url_?>images/gicon.png'
		});
		addlisten(courses[x][5],i[4]);
		
		bounds.extend(latlng);
	}
    map.fitBounds(bounds);
}

function addlisten(marker, url){
	google.maps.event.addListener(marker, 'click', function() {
		window.location=url;
	});
}
</script>