<?php 
	if($products == array()) {
?>
<div class="itemsBar top">
	<section class="styledBox">
		<h1 class="pull-left">Online Store</h1>
		<?php echo getCategoriasHtml($childsMenus); ?>
		<article class="noItems">There are no products under this category.</article>
	</section>
</div>
<?php }else{ ?>
<div class="itemsBar top">
	<section class="styledBox">
		<h1 class="pull-left">Online Store</h1>
		<?php echo getCategoriasHtml($childsMenus); ?>
		<ul class="items centeredTitle">
			<?php foreach($products as $p) { ?>
			<li>
				<article>
					<figure>
						<a href="<?php echo $p['link']; ?>"><img src="<?php echo _url_ . url_image('products/', $p['imagem'], 120, 100, 1, 1); ?>"	alt="<?php echo $p['nome']; ?>"></a>
						<figcaption><?php echo $p['nome']; ?></figcaption>
					</figure>
					<p>
						<?php if($p['preco_desconto'] != 0){ ?><span class="captionMini">€<?php echo $p['preco_desconto']; ?></span><?php } ?>
						<span class="caption label label-info">€<?php echo $p['preco']; ?></span>
					</p>
					<div class="buttons">
						<a href="<?php echo $p['link']; ?>" class="btn btn-small btn-info">Info</a>
						<a href="<?php echo $p['url_loja']; ?>" class="btn btn-small btn-success">Buy</a>
					</div>
				</article>
			</li>
			<?php } ?>
		</ul>
	</section>
</div>
<?php } ?>