<?php 
	if($courses == array()) {
?>
<section class="listing">
	<article class="styledBox">
		<div class="content msgOnly">
			You have not added any course to your favorites list.
		</div>
	</article>
</section>
<?php } ?>
<section class="listing">
	<?php foreach($courses as $course) { ?>
	<article class="styledBox">
		<figure><img src="<?php  echo ($course['image'] != "")?_url_ . url_image('imagens/', $course['image'], 100, 100, 1, 1):''; ?>"></figure>
		<div class="content">
			<ul class="buttons">
				<li><a href="" class="btn btn-small btn-danger removeFavBtn" data-id="<?php echo $course['id_course']; ?>"><i class="icon-trash icon-white"></i>Remove</a></li>
				<li><a href="<?php echo $course['url']; ?>" class="btn btn-small btn-primary">See More</a></li>
			</ul>
			<h1><a href="<?php echo $course['url']; ?>"><?php echo $course['name']; ?></a><span class="rating rating_<?php echo $course['rating']; ?>"></span></h1>
			<h2><a href="<?php echo $course['paisURL']; ?>"><?php echo $course['pais']; ?></a> &gt; <a href="<?php echo $course['estadoURL']; ?>"><?php echo $course['estado']; ?></a></h2>
			<p><?php echo $course['summary']; ?></p>
		</div>
	</article>
	<?php } ?>
</section>
<?php echo paginateHTML_custom($paginatedQuery); ?>
<div class="bannerFullWidth">
	<?php echo getRandomBanner($banners, 5); ?>
</div>

<div class="itemsBar">
	<section class="styledBox">
		<h1 class="pull-left">Online Store</h1>
		<ul class="shopCategories nav nav-pills pull-right">
	   		<li><a href="#">Category 1</a></li>
	   		<li><a href="#">Category 2</a></li>
	   		<li><a href="#">Category 3</a></li>
	   		<li><a href="#">Category 4</a></li>
	    </ul>
		<ul class="products centeredTitle">
			<li>
				<article>
					<figure>
						<img src="<?php echo _url_; ?>ximages/product_sample_block.jpg" alt="Product Pic">
						<figcaption>Product Name</figcaption>
					</figure>
					<p>
						<span class="captionMini">€15.00</span><span class="caption label label-info">€12.00</span>
					</p>
					<div class="buttons">
						<a href="" class="btn btn-small btn-info">Info</a>
						<a href="" class="btn btn-small btn-success">Buy</a>
					</div>
				</article>
			</li>
			<li>
				<article>
					<figure>
						<img src="<?php echo _url_; ?>ximages/product_sample_block_2.jpg" alt="Product Pic">
						<figcaption>Product Name</figcaption>
					</figure>
					<p>
						<span class="captionMini">€15.00</span><span class="caption label label-info">€12.00</span>
					</p>
					<div class="buttons">
						<a href="" class="btn btn-small btn-info">Info</a>
						<a href="" class="btn btn-small btn-success">Buy</a>
					</div>
				</article>
			</li>
			<li>
				<article>
					<figure>
						<img src="<?php echo _url_; ?>ximages/product_sample_block_3.jpg" alt="Product Pic">
						<figcaption>Product Name</figcaption>
					</figure>
					<p>
						<span class="captionMini">€15.00</span><span class="caption label label-info">€12.00</span>
					</p>
					<div class="buttons">
						<a href="" class="btn btn-small btn-info">Info</a>
						<a href="" class="btn btn-small btn-success">Buy</a>
					</div>
				</article>
			</li>
			<li>
				<article>
					<figure>
						<img src="<?php echo _url_; ?>ximages/product_sample_block_4.jpg" alt="Product Pic">
						<figcaption>Product Name</figcaption>
					</figure>
					<p>
						<span class="captionMini">€15.00</span><span class="caption label label-info">€12.00</span>
					</p>
					<div class="buttons">
						<a href="" class="btn btn-small btn-info">Info</a>
						<a href="" class="btn btn-small btn-success">Buy</a>
					</div>
				</article>
			</li>
			<li>
				<article>
					<figure>
						<img src="<?php echo _url_; ?>ximages/product_sample_block_5.jpg" alt="Product Pic">
						<figcaption>Product Name</figcaption>
					</figure>
					<p>
						<span class="captionMini">€15.00</span><span class="caption label label-info">€12.00</span>
					</p>
					<div class="buttons">
						<a href="" class="btn btn-small btn-info">Info</a>
						<a href="" class="btn btn-small btn-success">Buy</a>
					</div>
				</article>
			</li>
		</ul>
	</section>
</div>

<div class="bannerFullWidth">
	<?php echo getRandomBanner($banners, 6); ?>
</div>

<script src="http://maps.google.com/maps/api/js?sensor=false" type="text/javascript"></script>
<script type="text/javascript">
var map=null;
var courses=new Array();

<?php foreach($courses as $course) { ?>
courses.push(Array('<?php echo addslashes ($course['name']); ?>',
	<?php echo $course['lat']; ?>,
	<?php echo $course['lon']; ?>,
	10,
	'<?php echo $course['url']; ?>',
	null
));
<?php } ?>

function load_map(){
    var myOptions = {
      zoom: 4,
      mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    map = new google.maps.Map(document.getElementById("google_map"), myOptions);
    var bounds = new google.maps.LatLngBounds();
	for(var x in courses){
		var i=courses[x];
		var latlng=new google.maps.LatLng(i[1],i[2]);
		courses[x][5]= new google.maps.Marker({
			position: latlng,
			map: map,
			title: i[0],
			icon: 'http://www.moradia.pt/layout/img/gicon.png'
		});
		addlisten(courses[x][5],i[4]);
		
		bounds.extend(latlng);
	}
    map.fitBounds(bounds);
}

function addlisten(marker, url){
	google.maps.event.addListener(marker, 'click', function() {
		window.location=url;
	});
}
</script>