<?php

function hotel_get($id, $lat, $lng){
	if (!file_in_cache('hotel', $id, 30*24*60)){
		return hotel_update($id, $lat, $lng);
	}
	return file_cache_get('hotel', $id);
}

function hotel_update($id,  $lat, $lng){
	$max=3;
	$iSize=90;
	
	$url='http://api.meteobox.com/hotel.php?max='.$max.'&lat='.$lat.'&lng='.$lng.'&iSize='.$iSize;
	$json=file_get($url,'brasilocal:weather');
	

	$array=json_decode($json, true);
	if (!is_array($array)){
		return array();
	}	
	if ($array===false){
		return array();
	}
	//var_dump($array);
	foreach($array as &$a){

		unset($a['address']);
		unset($a['zip']);
		unset($a['city_hotel']);
		unset($a['cc1']);
		unset($a['ufi']);
		unset($a['preferred']);
		unset($a['nr_rooms']);
		unset($a['city_unique']);
		unset($a['city_preferred']);
		unset($a['continent_id']);
		unset($a['review_score']);
		unset($a['review_nr']);
		unset($a['public_ranking']);
		unset($a['desc_fr']);
		unset($a['desc_pt']);
		unset($a['desc_no']);
		unset($a['desc_el']);
		unset($a['desc_fr']);
		unset($a['desc_es']);
		unset($a['desc_de']);
		unset($a['desc_nl']);
		unset($a['desc_it']);
		unset($a['desc_ja']);
		unset($a['desc_zh']);
		unset($a['desc_pl']);
		unset($a['desc_ru']);
		unset($a['desc_sv']);
		unset($a['desc_ar']);
		unset($a['dist']);
	}
	
	//print_r($array);
	
	file_cache_write('hotel', $id, $array);
	
	return $array;
	
}