<?php

function foto_get($id, $lat, $lng, $raio=0.05){
	if (!file_in_cache("foto",$id, 99999999999999)) {
		return foto_update($id, $lat, $lng, $raio);
	}
	return file_cache_get('foto', $id);
}

function foto_update($id, $lat, $lng, $raio){
	$fotos=array();

	$dif=$raio;
	$max=12;

	$url="http://www.panoramio.com/map/get_panoramas.php?order=popularity&set=public&from=0&to=".($max+5)."&minx=".($lng-$dif)."&miny=".($lat-$dif)."&maxx=".($lng+$dif)."&maxy=".($lat+$dif)."&size=medium";
	$obj=json_decode(file_get($url), true);


	if (isset($obj["photos"])){
		$itens=$obj["photos"];

		$exclude=explode("\r\n",file_open("exclude_foto.txt"));
		$count=0;
		foreach($itens as $foto){
			if (!in_array($foto['photo_url'],$exclude)){
				$width=$foto["width"];
				$height=$foto["height"];

				if ($width>$height){
					$min_height=(int) (100/($width/$height));
					$min_width=100;
				}else{
					$min_width=(int) (100/($height/$width));
					$min_height=100;
				}
				$vspace=0;
				if ($width > $height){
					$vspace=(int) (100-(100*$height/$width))/2;
				}

				$image=$foto["photo_file_url"];
				$image_thumb=str_replace("medium", "thumbnail", $image);

				$fotos[]=array(
						'titulo'=>$foto['photo_title'],
						'titulo_js'=>string2alt((string) $foto['photo_title']),
						'link'=>url_correct($foto['photo_url']),

						'image'=>url_correct($image),
						'image_thumb'=>url_correct($image_thumb),

						'owner_url'=>url_correct($foto['owner_url']),
						'owner_name'=>$foto['owner_name'],
						'owner_name_js'=>string2alt((string) $foto['owner_name']),

						'width'=>$width,
						'height'=>$height,

						'width_thumb'=>$min_width,
						'height_thumb'=>$min_height,

						'vspace'=>$vspace,
				);
				$count++;
				if ($count>=$max){
					break;
				}
			}
		}

		file_cache_write("foto",$id,$fotos);
		return $fotos;
	}
}

function foto_size($url, $type='mini'){
	$sizes=array(
		''=>''
	);
	if (isset($sizes[$type])){
		
		
	}
	return $url;
}
