<?php

function file_open($file){//abrir um ficheiro local
	if (file_exists($file)){
		return file_get_contents($file);
	}else{
		return false;
	}
}

function file_get($url, $password=''){//Buscar um ficheiro a internet
	if (!function_exists("curl_init")){
		if ($password==''){
			return file_get_contents($url);
		}else{
			$opts = array(
					'http'=>array(
							'method'=>'GET',
							'header'=>'Authorization: Basic '.base64_encode("$password")
					)
			);
			$cont=stream_context_create($opts);
			return file_get_contents($url, 0, $cont);
		}
	}else{
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_TIMEOUT, 10);// 5 Sec
		curl_setopt($ch, CURLOPT_HEADER, 0);
		if ($password!=''){
			curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
			//curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
			curl_setopt($ch, CURLOPT_USERPWD, $password);
		}
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
		//curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1)");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
		$content = curl_exec($ch);
		curl_close($ch);
		return $content;
	}
	return false;
}

function file_write($file,$content, $chmod=0777){//guardar dados no Ficheiro
	if (!file_exists($file)){
		path_exists($file);
	}
	if ($handle = fopen($file, 'w')) {
		fwrite($handle, $content);
		fclose($handle);
		chmod($file, $chmod);
		return true;
	}
	return false;
}

function file_log($file,$content){//adiciona dados no Ficheiro
	if (is_writable($file) OR !file_exists($file)) {
		//chmod($file, 0777);
		if ($handle = fopen($file, 'a')) {
			fwrite($handle, $content."\r\n");
			fclose($handle);
			return true;
		}
	}
	return false;
}

function file_cache_get($tipo,$id){
	return file_txt2array(file_open(file_path_cache($tipo,$id)));
}

function file_cache_write($tipo,$id,$array){
	$file=file_path_cache($tipo,$id);
	if (file_write($file, file_array2txt($array))){
		return true;
	}else{
		return false;
	}
}

function file_array2txt($array){
	return serialize($array);
}

function file_txt2array($txt){
	if ($txt!=false){
		return unserialize($txt);
	}else{
		return array();
	}
}

function file_in_cache($tipo,$id,$time=10080){//Time= tempo em numero de minutos da ultima actualizao...
	$file=file_path_cache($tipo,$id);
	if (file_exists($file)){
		if (filemtime($file)>(time()-($time*60))){
			return true;
		}
	}
	return false;
}


function file_path_cache($tipo,$id){
	$tipos=array("foto", "video", "news", "hotel", "weather", "extra", "zip", "destaque", "error", "X");
	if (in_array($tipo, $tipos)){
		$pasta=floor($id/1000).'000';
		$pasta='cache/'.$tipo.'/'.$pasta.'/';
		$file=$id.'.tmp';
		/*if (!file_exists($pasta.$file) AND !is_dir($pasta)){
			path_exists($pasta);
		}*/
		return $pasta.$file;
	}
	return null;
}

function path_exists($file,$mod=0777){
	$path=substr($file,0,-strlen(strrchr($file,"/")));
	if (!file_exists($path)){
		if (strpos($path,"/")>0){
			path_exists($path,$mod);
		}
		mkdir($path."/", $mod);
		chmod($path, $mod);
	}
	if (file_exists($path)){
		return true;
	}
	return false;
}